#!/bin/bash

CVER=_v20

SDIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"

# Toolchains path
#TOOLCHAINDIR=/path/to/ndk_toolcahin

OPENSSL_PATH=$SDIR/src/openssl-1.0.2q
FFMPEG_PATH=$SDIR/src/ffmpeg
LIBOUT=$SDIR/lib

case "$(uname -s)" in
 CYGWIN*|MINGW32*|MSYS*)
  buildhost=msys
  wd=${2//\\/\/}
  windir=${wd//:/}
  ;;
 *)
  buildhost=linux
  ;;
esac


mkdir $LIBOUT 2>/dev/null

case "$1" in
	arm64-v8a)
		ARCH=arm64
		CPU=armv8-a
		INFOM="AArch64"
		TARGET_CFLAGS="-march=armv8-a -mfix-cortex-a53-835769 -D__ANDROID_API__=21"
		TARGET_LDFLAGS=""
		CONFIG_PARAMS="--disable-fast-unaligned"
		SSL_FLAGS="linux-aarch64 -DL_ENDIAN -D__ANDROID_API__=21"
		BUILDID=8
		;;
	armeabi-v7a)
		ARCH=arm
		CPU=armv7-a
		INFOM="ARMv7 NEON"
		TARGET_CFLAGS="-marm -march=armv7-a -mfloat-abi=softfp -mfpu=neon -mtune=cortex-a8 -mvectorize-with-neon-quad -D__ANDROID_API__=16"
		TARGET_LDFLAGS="-Wl,--fix-cortex-a8"
		CONFIG_PARAMS="--disable-fast-unaligned"
		SSL_FLAGS="android-armv7 -DL_ENDIAN -D__ANDROID_API__=16"
		BUILDID=7
		;;
	arm7)
		ARCH=arm
		CPU=armv7-a
		INFOM="ARMv7 VFP"
		TARGET_CFLAGS="-marm -march=armv7-a -mfloat-abi=softfp -mfpu=vfpv3-d16 -D__ANDROID_API__=16"
		TARGET_LDFLAGS="-Wl,--fix-cortex-a8"
		CONFIG_PARAMS="--disable-fast-unaligned --disable-neon"
		SSL_FLAGS="android-armeabi -DL_ENDIAN -D__ANDROID_API__=16"
		BUILDID=7v
		;;
	x86)
		ARCH=x86
		INFOM="x86"
		TARGET_CFLAGS="-march=i686 -mtune=atom -msse3 -mfpmath=sse -mincoming-stack-boundary=4 -D__ANDROID_API__=16"
		SSL_FLAGS="no-asm android-x86 -D__ANDROID_API__=16"
		CONFIG_PARAMS="--disable-decoder=dirac --disable-asm"
		BUILDID=x86
		;;
	x86_atom)
		ARCH=x86
		INFOM="x86"
		TARGET_CFLAGS="-march=atom -mno-sse4 -mno-sse4.2 -mincoming-stack-boundary=4 -D__ANDROID_API__=16"
		SSL_FLAGS="mo-asm android-x86 -D__ANDROID_API__=16"
		CONFIG_PARAMS="--disable-decoder=dirac --disable-asm"
		BUILDID=x86
		;;
	x86-64)
		ARCH=x86_64
		INFOM="x86-64"
		TARGET_CFLAGS="-march=x86-64 -D__ANDROID_API__=21"
		SSL_FLAGS="linux-x86_64 -D__ANDROID_API__=21"
		BUILDID=x86_64
		;;
	*)
		echo "Invalid parameter. Valid paramters are: arm64-v8a, armeabi-v7a, x86, x86-64.";
		exit
		;;
esac

COMMON_CFLAGS="-O3 -DNDEBUG"

if [[ -z "$TOOLCHAINDIR" ]]; then
PREBUILT=$SDIR/toolchains/$ARCH
else
PREBUILT=$TOOLCHAINDIR
fi
PLATFORM=$PREBUILT/sysroot

echo *Buliding for $INFOM*

if [ $ARCH == "arm64" ];
then
	export CC="$PREBUILT/bin/aarch64-linux-android-gcc"
	export AR="$PREBUILT/bin/aarch64-linux-android-ar"
	export CXX="$PREBUILT/bin/aarch64-linux-android-g++"
	export CROSS_PREFIX="$PREBUILT/bin/aarch64-linux-android-"
	export HOST="aarch64-linux-android"
elif [ $ARCH == "arm" ];
then
	export CC="$PREBUILT/bin/arm-linux-androideabi-gcc"
	export AR="$PREBUILT/bin/arm-linux-androideabi-ar"
	export CXX="$PREBUILT/bin/arm-linux-androideabi-g++"
	export CROSS_PREFIX="$PREBUILT/bin/arm-linux-androideabi-"
	export HOST="arm-linux-androideabi"
elif [ $ARCH == "x86" ];
then
	export CC="$PREBUILT/bin/i686-linux-android-gcc"
	export AR="$PREBUILT/bin/i686-linux-android-ar"
	export CXX="$PREBUILT/bin/i686-linux-android-g++"
	export CROSS_PREFIX="$PREBUILT/bin/i686-linux-android-"
	export HOST="i686-linux-android"
elif [ $ARCH == "x86_64" ];
then
	export CC="$PREBUILT/bin/x86_64-linux-android-gcc"
	export AR="$PREBUILT/bin/x86_64-linux-android-ar"
	export CXX="$PREBUILT/bin/x86_64-linux-android-g++"
	export CROSS_PREFIX="$PREBUILT/bin/x86_64-linux-android-"
	export HOST="x86_64-linux-android"
fi

export STRIP="$CROSS_PREFIX"strip

export PATH=$PREBUILT/$HOST/bin:$PATH

error_build() {
	echo $1
	exit
}

echo Builidng OpenSSL
cd $OPENSSL_PATH
find . -type f -name '*.o' | xargs rm
#if [ "$OSTYPE" = "msys" ] || ! hash makedepend 2>/dev/null; then
 mkdep="$CC -M"
#else
# mkdep="makedepend"
#fi
export CROSS_SYSROOT=$PLATFORM
make clean
MAKEDEPPROG="$mkdep" ./Configure no-shared no-hw no-idea no-bf no-cast no-seed no-md2 $SSL_FLAGS
make MAKEDEPPROG="$mkdep" depend
make MAKEDEPPROG="$mkdep"
if [ $? != 0 ]; then
	error_build "Error builidng OpenSSL"
	read
fi

cd $FFMPEG_PATH
find . -type f -name '*.o' | xargs rm
make distclean
echo Configuring FFmpeg...
 ./configure --target-os=linux \
	--arch=$ARCH \
	--cpu=$CPU \
	--enable-shared \
	--disable-static \
	--disable-doc \
	--disable-ffmpeg \
	--disable-ffplay \
	--disable-ffserver \
	--disable-ffprobe \
	--disable-avdevice \
	--disable-encoders \
	--disable-muxers \
	--disable-devices \
	--disable-protocols \
	--enable-openssl \
	--enable-optimizations \
	--enable-protocol=file \
	--enable-protocol=http \
	--enable-protocol=hls \
	--enable-protocol=mmsh \
	--enable-protocol=mmst \
	--enable-protocol=rtmp \
	--enable-protocol=rtmpe \
	--enable-protocol=rtmps \
	--enable-protocol=rtmpt \
	--enable-protocol=rtmpte \
	--enable-protocol=rtmpts \
	--enable-protocol=rtp \
	--enable-protocol=udp \
	--enable-protocol=https \
	--enable-protocol=tls_openssl \
	--enable-muxer=spdif \
	--enable-encoder=mjpeg \
	$FFMPEG_EXTRA_CONFIG $CONFIG_PARAMS \
	--disable-symver \
	--enable-cross-compile \
	--sysroot=$PLATFORM \
	--cross-prefix=$CROSS_PREFIX \
	--extra-cflags="-I$OPENSSL_PATH/include -I$PLATFORM/usr/include -fPIC -DANDROID $TARGET_CFLAGS" \
	--extra-ldflags="$TARGET_LDFLAGS -L$OPENSSL_PATH -L$PLATFORM/usr/lib"
make -j4
if [ $? != 0 ]; then
	error_build "Error builidng FFmpeg"
	read
fi

mv libavcodec 1

OBJ_FILES="$CC -shared -Wl,-soname,libffmpeg.so -Wl,-Bsymbolic -L1 -Llibavdevice -Llibavfilter -Llibavformat -Llibavresample -Llibavutil -Llibpostproc -Llibswscale -Llibswresample $TARGET_LDFLAGS -L$OPENSSL_PATH -L$PLATFORM/usr/lib --sysroot=$PLATFORM -Wl,--as-needed -Wl,--warn-common -Wl,-rpath-link=libpostproc:libswresample:libswscale:libavfilter:libavdevice:libavformat:1:libavutil:libavresample -o libffmpeg.so "

recurse_dir() {
 for i in "$1"/*;do
    if [ -d "$i" ];then
        recurse_dir "$i"
    elif [ -f "$i" ]; then
        if [ ${i: -2} == ".o" ]; then
        	ofile=" ${i#$FFMPEG_PATH/}"
        	if [ $ofile != "libavutil/reverse.o" ] && [ $ofile != "libavformat/golomb_tab.o" ] && [ $ofile != "libavformat/log2_tab.o" ] && [ $ofile != "libswresample/log2_tab.o" ] && [ $ofile != "libavutil/log2_tab.o" ] \
        	&& [ $ofile != "libswscale/log2_tab.o" ] && [ $ofile != "libavfilter/log2_tab.o" ] ;
        	then
        		#echo "file: $ff"
        		OBJ_FILES+=$ofile
        	fi
        fi
    fi
 done
}

recurse_dir $FFMPEG_PATH
OBJ_FILES+=" -lssl -lcrypto -lm -lz"

$OBJ_FILES
mv 1 libavcodec
$STRIP libffmpeg.so
mv libffmpeg.so $LIBOUT/libffmpeg$BUILDID$CVER.so
if [ $buildhost == "msys" ];
then
 cp $LIBOUT/libffmpeg$BUILDID$CVER.so /$windir/
fi

echo *DONE*
echo Press ENTER to continue
read
